#!/usr/bin/env python

# ATTENTION!
# Please do not manually edit the contents of this file
# Only use the web interface for editing
# Otherwise, the file may no longer be editable using the web interface, or you changes may be lost

# Copyright (c) 2016 mindsensors.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.    See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#mindsensors.com invests time and resources providing this open source code,
#please support mindsensors.com  by purchasing products from mindsensors.com!
#Learn more product option visit us @  http://www.mindsensors.com

"""
--BLOCKLY FILE--
--START BLOCKS--
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
356e094d266a4f341858934b0c32b08839d3b4ca355f103498411dad4ba485c5
--END BLOCKS--
"""


from PiStorms import PiStorms
import time
import random

i = None
random_speed = None

psm = PiStorms()

"""You can also define custom functions. This one will flash the
LED's with red and blue colors 10 times and then turn them off.

To save space, you can collapse blocks (like in the inside loop)
"""
def Flash_LED_s():
  for count in range(10):
    psm.led(1, 255, 0, 0)
    psm.led(2, 51, 51, 255)
    time.sleep(0.1)
    psm.led(2, 255, 0, 0)
    psm.led(1, 51, 51, 255)
    time.sleep(0.1)
  psm.led(1, 0, 0, 0)
  psm.led(2, 0, 0, 0)


# Blockly is a drag-and-drop programming interface that
# you can use to interact with PiStorms. It is very
# similar to Python and has most of its features.
#
# For example, this set of blocks displays "Blockly
# Example" as title on the screen, loops through
# numbers from 1 to 5, and prints them to the screen.
psm.screen.drawDisplay('Blockly Example', True)
for i in range(1, 6):
  psm.screen.termPrintln(i)
  time.sleep(0.2)

# This block will call the function defined earlier. You can
# find it in the "Functions" section of the menu to the left.
#
# You can also comment / disable the blocks. Right
# click on a block and select the option you want.
Flash_LED_s()

# The blocks are split into three main categories. The top ones (Logic -
# Color) are standard methods you can find an any programming language.
#
# The next two are user defined. This is where you can create new
# functions and variables and find blocks to call them from your code.
#
# The final menus (Motors - System) are blocks
# designed specifically to interact with PiStorms.
#
# When you are done coding, make sure to save the file.
# Bigger programs may take considerably longer to save.
for count2 in range(5):
  random_speed = random.randint(-100, 100)
  psm.BAM1.setSpeedSync(random_speed)
  time.sleep(1)
psm.BAM1.brakeSync()
